<?php
/**
 * Configuration File
 * Database connection and settings
 */

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);

// Database Configuration - CPANEL COMPATIBLE
define('DB_HOST', 'localhost');
define('DB_USER', 'root');  // Change this to your cPanel database user
define('DB_PASS', '');      // Change this to your cPanel database password
define('DB_NAME', 'sourcehub');

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Connect to MySQL
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS);

if ($conn->connect_error) {
    error_log("Database Connection Failed: " . $conn->connect_error);
    die("Database connection error. Please contact administrator.");
}

// Create database if not exists
$conn->query("CREATE DATABASE IF NOT EXISTS " . DB_NAME);
$conn->select_db(DB_NAME);
$conn->set_charset("utf8mb4");

// Create tables
$conn->query("
    CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        name VARCHAR(255) NOT NULL,
        email VARCHAR(255) NOT NULL UNIQUE,
        password VARCHAR(255) NOT NULL,
        role ENUM('user', 'admin') DEFAULT 'user',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
");

$conn->query("
    CREATE TABLE IF NOT EXISTS projects (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        slug VARCHAR(255) NOT NULL UNIQUE,
        short_description TEXT,
        long_description LONGTEXT,
        price DECIMAL(10, 2) NOT NULL,
        tech_stack VARCHAR(500),
        tags VARCHAR(500),
        image_path VARCHAR(255),
        file_path VARCHAR(255),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
");

$conn->query("
    CREATE TABLE IF NOT EXISTS orders (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id INT NOT NULL,
        project_id INT NOT NULL,
        amount DECIMAL(10, 2) NOT NULL,
        status ENUM('PENDING', 'SUCCESS', 'FAILED') DEFAULT 'PENDING',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (user_id) REFERENCES users(id),
        FOREIGN KEY (project_id) REFERENCES projects(id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
");

// Create admin if not exists
$admin_check = $conn->query("SELECT * FROM users WHERE email = 'admin@example.com'");
if ($admin_check->num_rows == 0) {
    $admin_pass = password_hash('password', PASSWORD_BCRYPT);
    $conn->query("INSERT INTO users (name, email, password, role) VALUES ('Admin User', 'admin@example.com', '$admin_pass', 'admin')");
}

// Insert sample projects if empty
$project_check = $conn->query("SELECT COUNT(*) as count FROM projects");
$project_result = $project_check->fetch_assoc();
if ($project_result['count'] == 0) {
    $projects = [
        ['React E-Commerce', 'react-ecommerce', 'Complete React e-commerce platform', 'A full-featured e-commerce system built with React and Node.js backend with payment integration and user management.', 49.99, 'React, Node.js, MongoDB', 'ecommerce,react,payment'],
        ['Laravel CMS', 'laravel-cms', 'Content management system', 'Powerful CMS for content management with multi-user support and role-based permissions.', 39.99, 'Laravel, MySQL, PHP', 'cms,laravel,php'],
        ['Vue Dashboard', 'vue-dashboard', 'Admin dashboard with Vue.js', 'Modern responsive admin dashboard with interactive charts and data tables.', 29.99, 'Vue.js, Chart.js, Tailwind', 'dashboard,vue,admin'],
        ['Mobile Chat App', 'mobile-chat', 'Real-time chat application', 'Mobile chat application with real-time updates and push notifications.', 59.99, 'React Native, Firebase', 'chat,mobile,realtime'],
        ['ML API', 'ml-api', 'Machine learning API', 'Python machine learning API for predictions and data analysis tasks.', 79.99, 'Python, TensorFlow, Flask', 'ml,api,python'],
        ['Blockchain Smart Contracts', 'blockchain-smart', 'Smart contracts for Ethereum', 'Solidity smart contracts for DeFi applications and token deployment.', 89.99, 'Solidity, Ethereum, Web3', 'blockchain,crypto,ethereum']
    ];
    
    foreach ($projects as $p) {
        $conn->query("INSERT INTO projects (title, slug, short_description, long_description, price, tech_stack, tags) 
                      VALUES ('{$p[0]}', '{$p[1]}', '{$p[2]}', '{$p[3]}', {$p[4]}, '{$p[5]}', '{$p[6]}')");
    }
}

?>
